(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[     65626,       1659]
NotebookOptionsPosition[     55313,       1473]
NotebookOutlinePosition[     56249,       1504]
CellTagsIndexPosition[     56177,       1499]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["1| Overview",
 FontColor->GrayLevel[0]]], "Section",
 CellFrame->{{0, 0}, {0, 2}},
 CellFrameColor->GrayLevel[0.75],
 CellChangeTimes->{{3.961317846403211*^9, 3.961317852747473*^9}, {
   3.964103633487542*^9, 3.964103634111524*^9}, 3.964103757850235*^9, 
   3.970567295842023*^9},
 CellTags->"overview",ExpressionUUID->"9000e81d-1adb-4a16-9934-246f43280c18"],

Cell["\<\
In Mathematica, finite element problems are treated as Partial Differential \
Equation or PDE problems and solved using the function NDSolve. This function \
requires the following parameters 
\ta) The equations to be solved, 
\tb) The output (sometimes called the dependent) variables, 
\tc) independent variables and the region over which the solution is required.\
\>", "Text",
 CellChangeTimes->{
  3.961291966492546*^9, {3.964103912140243*^9, 3.964103918814287*^9}, {
   3.9647458943198633`*^9, 3.964745983712813*^9}, {3.967630570513358*^9, 
   3.967630591466053*^9}, {3.9705383850545387`*^9, 3.970538400255747*^9}},
 FontWeight->"Regular",ExpressionUUID->"ea3f7d97-a91d-4798-836b-b90746080b8e"],

Cell["For structural problems:-", "Text",
 CellChangeTimes->{{3.967632658923956*^9, 3.967632667196176*^9}},
 CellID->1984170498,ExpressionUUID->"b7703d1e-b565-46b2-a271-e7b1ccfd0078"],

Cell["It may be represented by the following equation", "Text",
 CellChangeTimes->{{3.970539887200633*^9, 3.970539902900996*^9}},
 CellID->1467278564,ExpressionUUID->"10785b50-a4ae-4522-a32e-df01532f7258"],

Cell[BoxData[
 RowBox[{"displacement", " ", "=", " ", 
  RowBox[{"NDSolveValue", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"SolidMechanicsPDEComponent", "[", 
        RowBox[{"vars", ",", " ", "pars"}], "]"}], " ", "==", " ", "load"}], ",",
       " ", "boundaryConditions"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", " ", "y", ",", " ", "z"}], "]"}], ",", " ", 
      RowBox[{"v", "[", 
       RowBox[{"x", ",", " ", "y", ",", " ", "z"}], "]"}], ",", " ", 
      RowBox[{"w", "[", 
       RowBox[{"x", ",", " ", "y", ",", " ", "z"}], "]"}]}], "}"}], ",", " ", 
    
    RowBox[{"Element", " ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", " ", "y", ",", " ", "z"}], "}"}], ",", " ", 
      "domain"}], "]"}]}], "]"}]}]], "DisplayFormula",
 CellChangeTimes->{{3.9705399404822063`*^9, 3.970540016101462*^9}, 
   3.970540146403534*^9, {3.97054042751892*^9, 3.970540497082932*^9}, {
   3.970541003984289*^9, 3.970541005311619*^9}, {3.9705410404682617`*^9, 
   3.970541053925571*^9}, {3.970541090581457*^9, 3.970541090584921*^9}, {
   3.970541212131792*^9, 3.9705412257779713`*^9}},
 FontWeight->"Bold",
 CellID->379412489,ExpressionUUID->"a58a913a-028c-4479-98fa-108a7a8c8dd6"],

Cell["The parts of the equation are discussed  below.", "Text",
 CellChangeTimes->{{3.970542094489079*^9, 3.970542110512231*^9}},
 CellID->1891200242,ExpressionUUID->"53cc56a9-ed5a-4162-abce-aaf3b39c036c"],

Cell[CellGroupData[{

Cell["Variables (vars)", "Subsection",
 CellChangeTimes->{{3.9705421872953043`*^9, 3.9705422003674507`*^9}, {
  3.9705656130784616`*^9, 3.970565616407857*^9}},
 CellID->1223278165,ExpressionUUID->"c5c0f188-6828-461f-bffd-595a6b947fe3"],

Cell[TextData[{
 "\t",
 StyleBox["The output variables  are the displacement components u,v,w \
representing the displacements in the x,y, and z directions. Normally named ",
   "Text"],
 StyleBox["vars", "inTextCode",
  FontSize->16],
 StyleBox[", they are", "Text"]
}], "Text",
 CellChangeTimes->{{3.967632658923956*^9, 3.967632683177513*^9}, {
  3.970539278415537*^9, 3.970539302393032*^9}},
 CellID->285583223,ExpressionUUID->"f6300ff0-2599-4b65-82a2-14f61fe6d6bb"],

Cell["vars = {{u[x, y, z], v[x, y, z], w[x, y, z]}, {x, y, z}};\t", "Text",
 CellChangeTimes->{3.9559636992040777`*^9, 3.955964270363364*^9, 
  3.967646790088925*^9},
 TextAlignment->Center,
 FontFamily->"Source Sans Code",
 FontSize->13,
 FontWeight->"SemiBold",
 CellID->1505318698,ExpressionUUID->"0f047c9f-9182-423e-86db-cef7ea4c7a69"],

Cell[TextData[{
 StyleBox["\t", "Text"],
 StyleBox["The independent variables are the spatial coordinates ",
  FontFamily->"Baskerville"],
 StyleBox["x, y", "inTextCode",
  FontFamily->"Baskerville"],
 StyleBox[" and ",
  FontFamily->"Baskerville"],
 StyleBox["z", "inTextCode",
  FontFamily->"Baskerville"],
 StyleBox[" for three-dimensional problems, and possibly time",
  FontFamily->"Baskerville"],
 StyleBox[" ", "inTextCode",
  FontFamily->"Baskerville",
  FontWeight->"Plain"],
 StyleBox["t", "inTextCode",
  FontFamily->"Source Code Pro",
  FontSize->13],
 StyleBox[" ",
  FontFamily->"Source Code Pro",
  FontSize->13,
  FontWeight->"SemiBold"],
 StyleBox["for time-dependent analyses.",
  FontFamily->"Baskerville"]
}], "Text",
 CellChangeTimes->{{3.967632658923956*^9, 3.967632700824604*^9}},
 CellID->1770035463,ExpressionUUID->"b2a6452d-7461-4282-867e-63e1253200cb"],

Cell[TextData[StyleBox["Parameters (pars)", "Subsection"]], "Text",
 CellChangeTimes->{{3.967646812216724*^9, 3.967646814954668*^9}, {
  3.967646924987178*^9, 3.9676469287163277`*^9}, {3.970565633077775*^9, 
  3.9705656364299517`*^9}},
 CellID->1724741210,ExpressionUUID->"7c5052c9-2c66-4295-8170-4d485068908c"],

Cell[TextData[{
 "\tThe parameters ",
 StyleBox["pars",
  FontFamily->"Source Sans Code",
  FontSize->13,
  FontWeight->"SemiBold"],
 " are the material conditions, which are. "
}], "Text",
 CellChangeTimes->{{3.955963710884678*^9, 3.955963758188567*^9}, {
   3.955963821238427*^9, 3.9559638752547493`*^9}, {3.955963938221263*^9, 
   3.955963958498742*^9}, 3.955964188163254*^9, 3.955964321311799*^9, {
   3.955964563920556*^9, 3.9559645969579678`*^9}, 3.967647051291546*^9, {
   3.9705415312054768`*^9, 
   3.9705415512756863`*^9}},ExpressionUUID->"267a10ce-cf22-4201-b0f2-\
cb60d2d34cff"],

Cell[TextData[{
 StyleBox["<| ", "inTextCode",
  FontFamily->"Source Sans Code",
  FontSize->13,
  FontWeight->"SemiBold"],
 StyleBox[Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"\"\<YoungModulus\>\"", "->", "Y"}], ",", 
    RowBox[{"\"\<PoissonRatio\>\"", "->", "\[Nu]"}], ",", 
    RowBox[{"\"\<MassDensity\>\"", "=", "\[Gamma]"}], ",", 
    RowBox[{"\"\<ThermalConductivity\>\"", "->", "T"}]}], "|>"}]], 
  "inTextCode",
  CellChangeTimes->{
   3.9540871628713503`*^9, {3.954299606177107*^9, 3.954299683436338*^9}, 
    3.954300612861306*^9, {3.9558760957426357`*^9, 3.955876157986844*^9}},
  ExpressionUUID->"e787f474-bc5e-4da9-8e95-85f1cc9f61b9"], "inTextCode"]
}], "Text",
 CellChangeTimes->{
  3.955963923923234*^9, {3.964661785759039*^9, 3.964661785759111*^9}},
 TextAlignment->Center,ExpressionUUID->"942a3a0d-2446-43a8-9d16-7cddad9c93e2"],

Cell[TextData[{
 "Mass density and thermal conductivity are optional and only required if \
using self weight (",
 StyleBox["BodyLoadValue", "inTextCode"],
 ") and thermal calculations respectively. Other parameters may be \
specified."
}], "Text",
 CellChangeTimes->{
  3.955963912830558*^9, 3.955964004745163*^9, {3.9559646094910793`*^9, 
   3.955964609918078*^9}, {3.955964640001182*^9, 3.9559646504337873`*^9}, {
   3.970541567609932*^9, 
   3.9705415874116173`*^9}},ExpressionUUID->"5a046102-ce87-4f81-bfe3-\
94c75bc877cf"],

Cell[BoxData[
 StyleBox[
  RowBox[{
   StyleBox[
    RowBox[{"For", " ", "convenience"}],
    FontWeight->"Plain"], 
   StyleBox[",",
    FontWeight->"Plain"], " ", 
   RowBox[{
    StyleBox[
     RowBox[{"SolidMechanicsPDEComponent", "[", 
      RowBox[{"vars", ",", "pars"}], "]"}],
     FontSize->14], 
    StyleBox[" ",
     FontWeight->"Plain"], 
    StyleBox["is",
     FontWeight->"Plain"], 
    StyleBox[" ",
     FontWeight->"Plain"], 
    StyleBox["often",
     FontWeight->"Plain"], 
    StyleBox[" ",
     FontWeight->"Plain"], 
    StyleBox["shortened",
     FontWeight->"Plain"], 
    StyleBox[" ",
     FontWeight->"Plain"], 
    StyleBox["to",
     FontWeight->"Plain"]}]}], "Text"]], "Input",
 CellChangeTimes->{{3.970540544197439*^9, 3.970540559519814*^9}, {
  3.970540823921842*^9, 3.9705408315637913`*^9}},
 CellID->264532213,ExpressionUUID->"9db12904-00ab-49e4-8206-87edb213f2ef"],

Cell[TextData[{
 StyleBox["o",
  FontWeight->"SemiBold"],
 StyleBox["p=SolidMechanicsPDEComponent[vars,pars];",
  FontSize->14,
  FontWeight->"SemiBold"]
}], "Text",
 CellChangeTimes->{3.970540580904311*^9},
 TextAlignment->Center,
 FontWeight->"Bold",
 CellID->151183715,ExpressionUUID->"4c004224-250e-406b-a9dc-8924f7ffca44"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Boundary Conditions", "Subsection",
 CellChangeTimes->{{3.9559660091181517`*^9, 
  3.955966015277967*^9}},ExpressionUUID->"97d8875c-c6ed-4454-a87d-\
24e1daf6f049"],

Cell["\<\
Boundary conditions are required to fix the region in space and to load the \
structure, control the displacement of part of the structure, or define the \
initial conditions. \
\>", "Text",
 CellChangeTimes->{
  3.955963912830558*^9, 3.955964004745163*^9, {3.9559646094910793`*^9, 
   3.955964609918078*^9}, {3.955964640001182*^9, 3.955964648471778*^9}, {
   3.955964723461755*^9, 3.955964885703937*^9}, {3.955965012026444*^9, 
   3.955965027113945*^9}, 3.970541765103256*^9, {3.9705418336821823`*^9, 
   3.9705418536799707`*^9}, {3.970565682509776*^9, 3.970565701409706*^9}, {
   3.970565816458385*^9, 3.970565836679647*^9}},
 CellID->950750164,ExpressionUUID->"9a5ca7cb-b63a-4cb5-8537-2ca8831be28a"],

Cell[TextData[{
 "A typical boundary condition may be the ",
 Cell[BoxData[
  RowBox[{
   TemplateBox[{
     Cell[
      TextData["SolidFixedCondition"]], "paclet:ref/SolidFixedCondition"},
    "RefLink",
    BaseStyle->{"InlineFormula"}], "[", 
   RowBox[{
    StyleBox["pred", "TI"], ",", 
    StyleBox["vars", "TI"], ",", 
    StyleBox["pars", "TI"]}], "]"}]], "inTextCode",ExpressionUUID->
  "c003ef8a-3815-45c3-88ce-95956bf88e4f"],
 StyleBox["  ",
  FontFamily->"Source Sans Code",
  FontWeight->"SemiBold"],
 "which represents a fully constrained solid boundary for PDEs with predicate \
",
 Cell[BoxData[
  StyleBox["pred", "TI"]], "inTextCode",
  FontFamily->"Source Sans Pro",
  FontWeight->"Regular",
  FontSlant->"Italic",ExpressionUUID->
  "3033072a-e44e-47b5-8842-b8ca14f3a73e"],
 " indicating where it applies, with model variables ",
 Cell[BoxData[
  StyleBox["vars", "TI",
   FontFamily->"Times",
   FontSize->18,
   FontWeight->"Regular",
   FontSlant->"Italic"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "a748d102-e787-4e45-93c0-df3911809c7a"],
 " and output parameters ",
 Cell[BoxData[
  StyleBox["pars", "TI",
   FontFamily->"Times",
   FontSize->18,
   FontWeight->"Regular",
   FontSlant->"Italic"]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "d47fc2a3-4748-45bc-af95-cef436a1999a"],
 " as above. "
}], "Text",
 CellChangeTimes->{
  3.955963912830558*^9, 3.955964004745163*^9, {3.9559646094910793`*^9, 
   3.955964609918078*^9}, {3.955964640001182*^9, 3.955964648471778*^9}, {
   3.955964723461755*^9, 3.955964885703937*^9}, {3.955965012026444*^9, 
   3.955965027113945*^9}, 3.970541765103256*^9, {3.9705418336821823`*^9, 
   3.9705418372964773`*^9}, {3.9705419518233337`*^9, 3.9705419536319857`*^9}},
 
 CellID->1924935212,ExpressionUUID->"9be6d741-865c-4d3b-a444-8f62c4c251d4"],

Cell["Boundary conditions are of three main types:-", "Text",
 CellChangeTimes->{{3.955966054803097*^9, 3.955966072909602*^9}, {
   3.955966196825776*^9, 3.955966235198903*^9}, {3.955966303626356*^9, 
   3.955966318897688*^9}, 3.970541978822607*^9, {3.970565732628779*^9, 
   3.97056573362961*^9}},ExpressionUUID->"edcbfbeb-86fb-43e9-b58e-\
ec1f19789809"],

Cell[CellGroupData[{

Cell["Dirichlet Condition", "Subsubsection",
 CellChangeTimes->{{3.955966345358149*^9, 3.9559663759617968`*^9}, 
   3.964661840927473*^9},ExpressionUUID->"5590917a-7b53-4342-8cc1-\
794cceb8e8cf"],

Cell[TextData[{
 StyleBox["In structural problems, D", "Text"],
 StyleBox["irichletCondition ", "inTextCode",
  FontWeight->"SemiBold"],
 StyleBox["is used to specify essential boundary conditions for differential \
equations, such as fixing displacements at certain boundaries i.e. they fix \
the output values, u,v, or w at the positions x,y, or z.", "Text"]
}], "ItemParagraph",
 CellChangeTimes->{
  3.955966722845379*^9, {3.955966753210182*^9, 3.955966753211789*^9}, {
   3.9647470756521263`*^9, 3.9647471316753073`*^9}, {3.9705662673266287`*^9, 
   3.970566277761972*^9}},ExpressionUUID->"328f5eb6-5146-4bbe-921c-\
fdca40f6a788"],

Cell[TextData[{
 StyleBox["The typical syntax is", "Text"],
 " ",
 Cell[BoxData[
  TemplateBox[{
    Cell["DirichletCondition[u[x, y, z] == value, predicate]", Background -> 
     None]},
   "ChatCodeInlineTemplate"]], "ChatCodeActive",ExpressionUUID->
  "d9cf26c2-216f-40b1-8cc9-3158bcdb7eee"],
 ", ",
 StyleBox["where", "Text"],
 ": \n",
 Cell[TextData[{
  "   ",
  StyleBox["\[Bullet]",
   FontColor->GrayLevel[0.5]],
  " ",
  Cell[BoxData[
   TemplateBox[{
     Cell["u[x, y, z]", Background -> None]},
    "ChatCodeInlineTemplate"]], "ChatCodeActive",ExpressionUUID->
   "ab75c829-4bc4-44b4-b44f-429b3c0ad1fb"],
  " ",
  StyleBox["is the output variable (displacement)", "Text"],
  "."
 }], "InlineSubitem",ExpressionUUID->"94299bfc-da0d-4b00-83e1-5ae625ef8018"],
 "\n",
 Cell[TextData[{
  "   ",
  StyleBox["\[Bullet]",
   FontColor->GrayLevel[0.5]],
  " ",
  StyleBox["value", "inTextCode"],
  StyleBox[" is the prescribed value at the boundary.", "Text"]
 }], "InlineSubitem",ExpressionUUID->"c0c3ce95-9106-4405-916a-7a95fddb14fe"],
 "\n",
 Cell[TextData[{
  "   ",
  StyleBox["\[Bullet]",
   FontColor->GrayLevel[0.5]],
  " ",
  StyleBox["predicate", "inTextCode"],
  StyleBox[
  " is a logical condition specifying where the boundary condition applies, \
such as ", "Text"],
  StyleBox[Cell[BoxData[
   TemplateBox[{
     Cell[
      TextData[
       StyleBox["x == 0", "inTextCode"]], Background -> None]},
    "ChatCodeInlineTemplate"]], "Text",ExpressionUUID->
   "4aede6d5-35fa-445d-925b-e4df11d6fe65"], "Text"],
  StyleBox[" or ", "Text"],
  StyleBox[Cell[BoxData[
   TemplateBox[{
     Cell[
      TextData[
       StyleBox["y > 0.5", "inTextCode"]], Background -> None]},
    "ChatCodeInlineTemplate"]], "Text",ExpressionUUID->
   "0e4a88ae-dc0f-41d7-aa1d-c41f07acb4db"], "Text"],
  StyleBox[". ", "Text"]
 }], "InlineSubitem",ExpressionUUID->"8b722e27-bd86-4ea7-a21e-c7a145f375e5"]
}], "Subitem",
 CellChangeTimes->{{3.9559667975844927`*^9, 3.9559668092355757`*^9}, {
  3.955966840029304*^9, 3.955966856835383*^9}, {3.9643148388514347`*^9, 
  3.964314839693297*^9}, {3.9647471675276823`*^9, 3.964747169791996*^9}, {
  3.96764766752745*^9, 
  3.96764767093392*^9}},ExpressionUUID->"7d0ea4e5-8463-49f0-a482-\
8e41c95e3590"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["For example to fix the displacement in the ", "Text"],
 StyleBox["x", "inTextCode"],
 StyleBox[" direction  to ", "Text"],
 StyleBox["0", "inTextCode"],
 StyleBox[" at ", "Text"],
 StyleBox["x=0", "inTextCode"],
 StyleBox[", say at the end of a beam", "Text"]
}], "Subitem",
 CellChangeTimes->{{3.9559667975844927`*^9, 3.9559668092355757`*^9}, {
  3.955966840029304*^9, 3.955966922062361*^9}, {3.9559669589924297`*^9, 
  3.955967012571258*^9}},ExpressionUUID->"32ced986-c698-4b54-ba26-\
a32d8ce1a956"],

Cell[TextData[StyleBox["DirichletCondition[u[x, y, z] == 0, x == 0]",
 FontWeight->"SemiBold"]], "Subsubitem",
 CellChangeTimes->{{3.9559667975844927`*^9, 3.9559668092355757`*^9}, {
  3.955966840029304*^9, 3.9559668836365013`*^9}, {3.9559670490418797`*^9, 
  3.9559670490438538`*^9}},ExpressionUUID->"91274449-1ebc-4c0a-918b-\
668af05efda1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Multiple Dirichlet conditions must not overlap on the boundary, \
although overlap of Dirichlet Conditions is okay, if the dependent variables \
are different. ", "Text"],
 StyleBox["DirichletCondition[{u[x, y, z] == 0, v[x,y,z] == 0}, x == 0]", 
  "inTextCode",
  FontWeight->"SemiBold"],
 StyleBox[" for example is okay. Simply, you should not try to specify a \
boundary  displacement in the same direction more than once in the same \
equation. Also, a Dirichlet condition and a Neumann value should not be \
specified on the same part of the boundary. ", "Text"]
}], "Subitem",
 CellChangeTimes->{{3.9559667975844927`*^9, 3.9559668092355757`*^9}, {
   3.955966840029304*^9, 3.9559668836365013`*^9}, 3.955967053465124*^9, {
   3.964746561763157*^9, 3.964746853757085*^9}, {3.9676479324604053`*^9, 
   3.967647960254387*^9}, 
   3.970566252109239*^9},ExpressionUUID->"33681a0f-302e-4d32-bfb7-\
686d786c880a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Neumann Values ", "Subsubsection",
 CellChangeTimes->{{3.955966345358149*^9, 3.955966399193714*^9}, 
   3.9559670662105837`*^9, {3.955982829402211*^9, 3.955982842527112*^9}, 
   3.955983132534667*^9, {3.9646618627550507`*^9, 3.964661880257393*^9}, {
   3.964747253473575*^9, 
   3.964747291632688*^9}},ExpressionUUID->"32c02010-019c-448d-8006-\
da4842f02ffc"],

Cell["\<\
Neumann values are used to specify force or pressures at a boundary.\
\>", "Text",
 CellChangeTimes->{{3.955966345358149*^9, 3.955966399193714*^9}, 
   3.9559670662105837`*^9, {3.955982829402211*^9, 3.955982829403079*^9}, {
   3.955982862470379*^9, 3.9559829003157377`*^9}, 3.955982969308688*^9, 
   3.9647468843736753`*^9, {3.9647473249937963`*^9, 
   3.964747326821808*^9}},ExpressionUUID->"2ccf8dde-cb55-433f-8471-\
fc19ebb01cb9"],

Cell["The typical syntax is", "Text",
 CellChangeTimes->{{3.955966345358149*^9, 3.955966399193714*^9}, 
   3.9559670662105837`*^9, {3.955982987800303*^9, 3.955983020820765*^9}, {
   3.955983155776009*^9, 
   3.955983155777162*^9}},ExpressionUUID->"1910f739-dbf1-4bac-958e-\
41a24ce0fa38"],

Cell[TextData[StyleBox["NeumannValue[expression, predicate]", "inTextCode"]], \
"Subsubitem",
 CellChangeTimes->{{3.955966345358149*^9, 3.955966399193714*^9}, 
   3.9559670662105837`*^9, {3.955982987800303*^9, 3.955983020820765*^9}, {
   3.9559831582084103`*^9, 
   3.955983171087563*^9}},ExpressionUUID->"7159d8b4-e5d8-4ec8-ad99-\
814a9bf708e3"],

Cell["\<\
Where the expression is the force or pressure and the predicate is a \
condition specifying where the force is to be applied.\
\>", "Text",
 CellChangeTimes->{{3.955966345358149*^9, 3.955966399193714*^9}, 
   3.9559670662105837`*^9, {3.955982987800303*^9, 3.955983020820765*^9}, {
   3.9559831582084103`*^9, 3.955983238918145*^9}, 3.955983285211129*^9, {
   3.9640881153277407`*^9, 
   3.96408811735564*^9}},ExpressionUUID->"3fe44dd3-c081-4de0-b233-\
4711c87333ed"],

Cell[TextData[{
 "For example to apply a vertical force on the top surface of a beam where \
the vertical coordinate of that surface is ",
 StyleBox["y=1.", "inTextCode"]
}], "Text",
 CellChangeTimes->{{3.955966345358149*^9, 3.955966399193714*^9}, 
   3.9559670662105837`*^9, {3.955982987800303*^9, 3.955983115489272*^9}, 
   3.96764804694392*^9},ExpressionUUID->"11e81e19-392c-4ba7-9e14-\
86f610668824"],

Cell[TextData[Cell[BoxData[
 RowBox[{"NeumannValue", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1000"}], "}"}], ",", 
   RowBox[{"y", "==", "0.1"}]}], 
  "]"}]], "Input",ExpressionUUID->"11c0672a-7f73-49bc-ba4e-f8589e73fb3e"]], \
"Subsubitem",
 CellChangeTimes->{{3.955966345358149*^9, 3.955966399193714*^9}, 
   3.9559670662105837`*^9, {3.955982987800303*^9, 
   3.9559831194032297`*^9}},ExpressionUUID->"88a66a3f-7108-412d-b845-\
26b7483ca25b"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Robin Neumann Values ", "Subsubsection",
 CellChangeTimes->{{3.955966345358149*^9, 3.9559664244829082`*^9}, 
   3.955967069134718*^9, {3.9559835429617987`*^9, 3.95598354296276*^9}, 
   3.964661889834536*^9, {3.9647473005425663`*^9, 
   3.964747312709174*^9}},ExpressionUUID->"9d3b4d68-ecb3-4d47-a0fe-\
2ef74ffd4d63"],

Cell["\<\
In structural mechanics, Robin values can model scenarios where a combination \
of displacement and force constraints apply, such as a boundary in contact \
with  a spring or damper. \
\>", "Text",
 CellChangeTimes->{{3.955983558320113*^9, 3.95598358384859*^9}, 
   3.955983648455516*^9, {3.955983683765147*^9, 3.955983732243853*^9}, {
   3.9647473192787952`*^9, 
   3.964747320897932*^9}},ExpressionUUID->"de52b838-a710-403d-90f9-\
2d194e543687"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["The typical syntax is ", "Text"]], "Subitem",
 CellChangeTimes->{{3.955983558320113*^9, 3.95598358384859*^9}, 
   3.955983648455516*^9, {3.955983683765147*^9, 
   3.955983758121169*^9}},ExpressionUUID->"9f852bbb-83c8-4304-ab8e-\
3a69505d303e"],

Cell[TextData[Cell[BoxData[
 RowBox[{"NeumannValue", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"c", " ", 
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "+", "b"}], ",", 
   "predicate"}], 
  "]"}]], "Input",ExpressionUUID->"0aaca6b9-5bfd-4857-af64-23f1f219fee2"]], \
"Subsubitem",
 CellChangeTimes->{{3.955983558320113*^9, 3.95598358384859*^9}, 
   3.955983648455516*^9, {3.955983683765147*^9, 3.955983707691424*^9}, {
   3.955983787911777*^9, 
   3.955983795650915*^9}},ExpressionUUID->"6fa1e672-445d-4675-95d2-\
76e90dd2c7aa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["where c is a coefficient representing the \
relationship between displacement force and the predicate specifies the \
location of the condition eg.", "Text"]], "Subitem",
 CellChangeTimes->{{3.955983558320113*^9, 3.95598358384859*^9}, 
   3.955983648455516*^9, {3.955983683765147*^9, 3.955983707691424*^9}, {
   3.9559838269837513`*^9, 
   3.955983926756205*^9}},ExpressionUUID->"e7ad7903-5750-461d-9f7a-\
957712b89755"],

Cell[TextData[{
 " ",
 StyleBox["NeumannValue[-k u[x],x==1]",
  FontWeight->"SemiBold"]
}], "Subsubitem",
 CellChangeTimes->{{3.955983558320113*^9, 3.95598358384859*^9}, 
   3.955983648455516*^9, {3.955983683765147*^9, 3.955983707691424*^9}, {
   3.9559838269837513`*^9, 3.9559839269474773`*^9}, 
   3.9559843749643*^9},ExpressionUUID->"d5eda755-e58d-423a-a368-c72da9bdeea2"]
}, Open  ]],

Cell[TextData[{
 StyleBox["where ", "Text"],
 StyleBox["k", "Text",
  FontWeight->"SemiBold"],
 StyleBox[" is a spring constant eg. ", "Text"],
 StyleBox[Cell[BoxData[
  FormBox[
   RowBox[{"1000", 
    FractionBox["N", "m"], "and", " "}], TraditionalForm]], "Text",
  ExpressionUUID->"0a2a8193-7f17-425b-bdd8-83841f819931"], "Text"],
 StyleBox[" ", "Text"],
 StyleBox["u[x]", "Text",
  FontWeight->"SemiBold"],
 StyleBox[" indicates the direction and ", "Text"],
 StyleBox["x==1", "Text",
  FontWeight->"SemiBold"],
 StyleBox[" the position of the spring.", "Text"]
}], "Subitem",
 CellChangeTimes->{{3.955983558320113*^9, 3.95598358384859*^9}, 
   3.955983648455516*^9, {3.955983683765147*^9, 3.955983707691424*^9}, {
   3.9559838269837513`*^9, 3.9559839245158987`*^9}, {3.955984416179847*^9, 
   3.955984515190796*^9}},ExpressionUUID->"58ddb436-52cc-4a50-a9b1-\
c4f39e8f3aaf"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Application of boundary conditions and values", "Subsection",
 CellChangeTimes->{{3.955985889092552*^9, 3.955985891636952*^9}, {
  3.9559859523385677`*^9, 3.955985955520857*^9}, {3.9612979529793463`*^9, 
  3.961297960927349*^9}, {3.964747366557847*^9, 3.964747369765765*^9}},
 FontSize->18,ExpressionUUID->"8dfed67b-5a9a-4f6c-a2ec-0ff8aa6a0665"],

Cell[TextData[{
 "Neumann or any of the  value conditions, like ",
 StyleBox["SolidBoundaryLoadValue",
  FontWeight->"SemiBold"],
 " must be positioned  on a surface and include an area, represented by a ",
 StyleBox["BoundaryElementMarker", "inTextCode"],
 ". or an area that includes at least one point. \n\nDisplacement, or \
Dirichlet Conditions, like ",
 StyleBox["SolidDisplacementCondition",
  FontWeight->"SemiBold"],
 " must be applied to a point or an area represented by a  \
PointElementMarker.  Positions must be specified exactly at a point or with a \
range to ensure a point is included.\n\nMultiple Neumann conditions are added \
together. A comma should then separate them from the Dirichlet conditions, \
which each  should be listed with a comma between. They should not be \
enclosed in curly brackets."
}], "Text",
 CellChangeTimes->{{3.955986096991076*^9, 3.955986451110901*^9}, {
   3.9559865892458963`*^9, 3.95598667515446*^9}, {3.956068412352271*^9, 
   3.95606844019419*^9}, {3.961293263680793*^9, 3.9612933283102627`*^9}, {
   3.964088190152083*^9, 3.9640882283956747`*^9}, {3.964661924402532*^9, 
   3.96466192877535*^9}, {3.964746953713972*^9, 3.964746954075645*^9}, {
   3.9647477011150103`*^9, 3.964747869615081*^9}, 3.9647479654833612`*^9, {
   3.964748102973777*^9, 3.96474813348144*^9}, {3.964748849173154*^9, 
   3.964748850309628*^9}, {3.964748888169746*^9, 3.964748919608959*^9}, 
   3.964748950644539*^9, {3.9647489867791567`*^9, 3.96474901278791*^9}, 
   3.964749069085547*^9, {3.970566465764092*^9, 
   3.970566471166683*^9}},ExpressionUUID->"31166b09-4824-4b71-9ef7-\
e3d440d175ef"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Standard Boundary Conditions", "Subsection",
 CellChangeTimes->{{3.955984603767519*^9, 3.955984627967161*^9}},
 FontSize->18,ExpressionUUID->"53f4e9b2-d2d6-4f9c-9c72-3aba2d6da233"],

Cell[TextData[{
 "Dirichlet conditions, can be generated directly, or by ",
 StyleBox["SolidFixedCondition", "inTextCode",
  FontWeight->"Bold"],
 " or ",
 StyleBox["SolidDisplacementCondition ", "inTextCode",
  FontWeight->"Bold"],
 "and Neumann conditions, directly or by ",
 StyleBox["SolidBoundaryLoadValue", "inTextCode",
  FontWeight->"Bold"],
 "."
}], "Text",
 CellChangeTimes->{{3.970566479344545*^9, 3.970566608301301*^9}, {
  3.9705667193082848`*^9, 3.9705667568933077`*^9}},
 CellID->1937046888,ExpressionUUID->"223a92e7-f892-4b4d-acd9-817981bba5bf"],

Cell[TextData[StyleBox["SolidFixedCondition",
 FontWeight->"Bold"]], "Item",
 CellChangeTimes->{{3.9559847415854197`*^9, 3.955984767244433*^9}, {
  3.955984855249596*^9, 
  3.9559848552506027`*^9}},ExpressionUUID->"a9e32cfa-11c7-4b64-8c1e-\
7063e55565af"],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[Cell[TextData[{
  Cell[BoxData[
   RowBox[{
    StyleBox[
     TemplateBox[{
       Cell[
        TextData["SolidFixedCondition"]], "paclet:ref/SolidFixedCondition"},
      "RefLink",
      BaseStyle->{"InlineFormula"}],
     FontSize->16.206750000000003`,
     FontWeight->"SemiBold"], 
    StyleBox["[",
     FontSize->16.206750000000003`,
     FontWeight->"SemiBold"], 
    RowBox[{
     StyleBox[
      StyleBox["pred", "TI"],
      FontSize->16.206750000000003`,
      FontWeight->"SemiBold"], 
     StyleBox[",",
      FontSize->16.206750000000003`,
      FontWeight->"SemiBold"], 
     StyleBox[
      StyleBox["vars", "TI"],
      FontSize->16.206750000000003`,
      FontWeight->"SemiBold"], 
     StyleBox[",",
      FontSize->16.206750000000003`,
      FontWeight->"SemiBold"], 
     RowBox[{
      StyleBox[
       StyleBox["par", "TI"],
       FontSize->16.206750000000003`,
       FontWeight->"SemiBold"], 
      StyleBox["s", "TI"]}]}], "]"}]], "InlineFormula",
   FontFamily->"Source Sans Pro",ExpressionUUID->
   "be873131-214e-499d-b19b-0b99e0f7efca"],
  "  "
 }],ExpressionUUID->
  "340d0ce7-02c7-44c2-b0b4-41738fd2e8fb"]],ExpressionUUID->"f87afdc9-2d97-\
4885-8320-1cd96341e079"]], "Subitem",
 CellChangeTimes->{{3.9559847415854197`*^9, 3.955984767244433*^9}, 
   3.955984860319117*^9, {3.955985167386508*^9, 3.955985176836739*^9}, {
   3.955986756448813*^9, 
   3.955986760244771*^9}},ExpressionUUID->"78eccbc0-29b8-43cd-9d6b-\
4403c10c7594"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["represents a fully constrained solid boundary for PDEs with \
predicate ", "Text"],
 StyleBox[Cell[BoxData[
  StyleBox["pred", "TI"]], "Text",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "0d461081-e99b-4006-8426-4e5a02ab68fa"], "Text"],
 StyleBox[" indicating where it applies, with model variables ", "Text"],
 StyleBox[Cell[BoxData[
  StyleBox["vars", "TI"]], "Text",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "13b2002f-dd0a-4363-8880-05baef53093e"], "Text"],
 StyleBox[" and global parameters ", "Text"],
 StyleBox[Cell[BoxData[
  StyleBox["pars", "TI"]], "Text",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "655b12bb-1203-4c75-a981-9015407d97cd"], "Text"],
 "."
}], "SubitemParagraph",
 CellChangeTimes->{
  3.955986778162477*^9},ExpressionUUID->"b7d9deb7-4725-48a8-8b9a-\
af2cc73b46de"],

Cell[TextData[Cell[BoxData[
 TemplateBox[{
   Cell[
    TextData["SolidDisplacementCondition"]], 
   "paclet:ref/SolidDisplacementCondition"},
  "RefLink",
  BaseStyle->{"InlineFormula"}]],
 FontFamily->"Source Sans Pro",
 FontWeight->
  "Bold",ExpressionUUID->"e3a563c6-cd94-4ae1-86a5-f2623b4eae78"]], "Item",
 CellChangeTimes->{{3.9559847415854197`*^9, 3.955984767244433*^9}, 
   3.955984860319117*^9, {3.955985167386508*^9, 
   3.955985180254409*^9}},ExpressionUUID->"81901aef-a357-4781-a761-\
01e4f995525a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox[
    TemplateBox[{
      Cell[
       TextData["SolidDisplacementCondition"]], 
      "paclet:ref/SolidDisplacementCondition"},
     "RefLink",
     BaseStyle->{"InlineFormula"}],
    FontSize->16.206750000000003`,
    FontWeight->"SemiBold"], 
   StyleBox["[",
    FontSize->16.206750000000003`,
    FontWeight->"SemiBold"], 
   StyleBox[
    RowBox[{
     StyleBox["pred", "TI"], ",", 
     StyleBox["vars", "TI"], ",", 
     StyleBox["pars", "TI"]}],
    FontSize->16.206750000000003`,
    FontWeight->"SemiBold"], "]"}]], "InlineFormula",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "67563cca-5c11-40f1-abca-5cfce4be848f"],
 " \[LineSeparator]",
 StyleBox["represents a prescribed displacement on a solid boundary for PDEs \
with predicate ", "Text"],
 StyleBox[Cell[BoxData[
  StyleBox["pred", "TI"]], "Text",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "3f9c8dcd-3a57-495b-b2cf-063a5b3143e7"], "Text"],
 StyleBox[" indicating where it applies, with model variables ", "Text"],
 StyleBox[Cell[BoxData[
  StyleBox["vars", "TI"]], "Text",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "91e213ab-b376-4ea3-aacb-5fdfa54a0333"], "Text"],
 StyleBox[" and global parameters ", "Text"],
 StyleBox[Cell[BoxData[
  StyleBox["pars", "TI"]], "Text",
  FontFamily->"Source Sans Pro",ExpressionUUID->
  "6e8855aa-c785-4c62-b382-3d3b8efe08cc"], "Text"],
 StyleBox[".", "Text"]
}], "Subitem",
 CellChangeTimes->{{3.9559847415854197`*^9, 3.9559847688364763`*^9}, 
   3.9559850697349787`*^9, {3.955985135258297*^9, 
   3.955985135259966*^9}},ExpressionUUID->"1c608910-16a1-43ae-be47-\
f75bbd193866"],

Cell[TextData[StyleBox["SolidBoundaryLoadValue",
 FontWeight->"Bold"]], "Item",
 CellChangeTimes->{{3.9559847415854197`*^9, 3.9559847688364763`*^9}, 
   3.9559850697349787`*^9, 3.955985145889825*^9, {3.9559867261122837`*^9, 
   3.955986726113977*^9}, {3.956068531715589*^9, 3.956068537169857*^9}, {
   3.956070398999044*^9, 
   3.9560703990001307`*^9}},ExpressionUUID->"0520b23e-629a-4ff7-96bf-\
35a8812737c0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 StyleBox[
  RowBox[{
   TemplateBox[{
     Cell[
      TextData["SolidBoundaryLoadValue"]], 
     "paclet:ref/SolidBoundaryLoadValue"},
    "RefLink",
    BaseStyle->{"InlineFormula"}], "[", 
   RowBox[{
    StyleBox["pred", "TI"], ",", 
    StyleBox["vars", "TI"], ",", 
    StyleBox["pars", "TI"], ",", 
    StyleBox["lkeys", "TI"]}], "]"}],
  FontSize->15.435000000000002`,
  FontWeight->"SemiBold"]], "InlineFormula",
 FontFamily->
  "Source Sans Pro",ExpressionUUID->"109ee5fb-d711-46a7-8325-6e2429ca2bca"]], \
"Subitem",
 CellChangeTimes->{{3.9559847415854197`*^9, 3.9559847688364763`*^9}, 
   3.9559850697349787`*^9, 3.955985145889825*^9, {3.9559867261122837`*^9, 
   3.955986726113977*^9}, {3.956068531715589*^9, 3.956068537169857*^9}, {
   3.956070406766921*^9, 
   3.9560704248204613`*^9}},ExpressionUUID->"3c41ced6-9816-4419-96a8-\
32b18125e763"],

Cell[TextData[{
 StyleBox["lkeys",
  FontSlant->"Italic"],
 " ",
 StyleBox["represents local parameters such as", "Text"],
 "  ",
 StyleBox["<|\[OpenCurlyDoubleQuote]Force\[CloseCurlyDoubleQuote] \
->{0,0,-100N}|> ",
  FontWeight->"SemiBold"],
 " or  ",
 StyleBox["<|\[OpenCurlyDoubleQuote]Pressure\[CloseCurlyDoubleQuote]-> \
{0,0,-100kPa}|>",
  FontWeight->"SemiBold"]
}], "SubitemParagraph",
 CellChangeTimes->{{3.9559847415854197`*^9, 3.9559847688364763`*^9}, 
   3.9559850697349787`*^9, 3.955985145889825*^9, {3.9559867261122837`*^9, 
   3.955986726113977*^9}, {3.956068531715589*^9, 3.956068537169857*^9}, 
   3.956070406766921*^9, {3.9560704552470713`*^9, 3.956070507100121*^9}, {
   3.956070537943441*^9, 
   3.9560706423746977`*^9}},ExpressionUUID->"c4e3a746-939d-4ce6-92bd-\
5eff68d12ce9"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Self weight", "Subsubsection",
 CellChangeTimes->{{3.9559847415854197`*^9, 3.9559847688364763`*^9}, 
   3.9559850697349787`*^9, 3.955985145889825*^9, {3.9559867261122837`*^9, 
   3.955986726113977*^9}, {3.956068531715589*^9, 3.956068561715476*^9}},
 FontSize->18,ExpressionUUID->"9e8091d8-b2de-471e-a2ad-e04d4487c33d"],

Cell[TextData[{
 StyleBox["Body forces are forces which act on the whole object and are in \
the units ", "Text"],
 StyleBox[Cell[BoxData[
  FormBox[
   FractionBox["N", 
    SuperscriptBox["m", "3"]], TraditionalForm]], "Text",ExpressionUUID->
  "87c72cc6-a5bc-4348-b924-146531506b41"], "Text"],
 StyleBox[". The most common body force is self weight acting on by gravity \
i.e. mass density x acceleration due to gravity or \[Rho]g. This can \
calculated and then entered as a parameter using the ", "Text"],
 StyleBox["BodyLoad", "Text",
  FontWeight->"SemiBold"],
 StyleBox[" parameter, or, more conveniently, especially in complex \
structures, entered using the ", "Text"],
 StyleBox["BodyLoadValue", "Text",
  FontWeight->"SemiBold"],
 StyleBox[" parameter. One of these parameters should be added to the ", 
  "Text"],
 StyleBox["Association", "Text",
  FontWeight->"SemiBold"],
 StyleBox[" of parameters as shown below. Note that the sign convention has \
z, positive upward so gravitational loads are, normally negative.", "Text"]
}], "ItemParagraph",
 CellChangeTimes->{{3.956068586925528*^9, 3.9560687377836637`*^9}, 
   3.9560690631530724`*^9, {3.956069824849737*^9, 3.9560698329177723`*^9}, {
   3.9647491407860928`*^9, 3.964749186507646*^9}, {3.970566790020647*^9, 
   3.970566837087358*^9}},ExpressionUUID->"71b89045-65ff-47b0-9036-\
a8213cc23d88"],

Cell[BoxData[
 RowBox[{"\"\<BodyLoad\>\"", "->", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", 
    RowBox[{"\"\<MassDensity\>\"", " ", "g", " ", "volume"}]}], "}"}], 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "g", " ", "is", " ", "the", " ", "acceleration", " ", "due", " ", "to", " ",
      "gravity"}], " ", "=", " ", 
    RowBox[{"-", "9.81"}]}], "*)"}]}]], "Input",
 Evaluatable->False,
 CellChangeTimes->{{3.956069099424781*^9, 3.956069242659327*^9}, {
  3.95606929949902*^9, 3.9560693052764378`*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"ae0fd256-5794-4782-8281-3a98dd7343ce"],

Cell[BoxData[
 RowBox[{"\"\<BodyLoadValue\>\"", "->", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", 
    RowBox[{"-", "9.81"}]}], "}"}], "\t", 
  RowBox[{"(*", 
   RowBox[{
   "MassDensity", " ", "to", " ", "be", " ", "included", " ", "in", " ", 
    "material", " ", "parameters"}], "*)"}]}]], "Input",
 Evaluatable->False,
 CellChangeTimes->{{3.9559847415854197`*^9, 3.9559847688364763`*^9}, 
   3.9559850697349787`*^9, 3.955985145889825*^9, {3.9559867280598*^9, 
   3.955986733891857*^9}, 3.956068371402112*^9, {3.956069073148847*^9, 
   3.956069089512966*^9}, {3.956069755358699*^9, 3.95606979868928*^9}, {
   3.964749266010054*^9, 
   3.9647493026351347`*^9}},ExpressionUUID->"bf00fd59-421f-4b2d-a574-\
c29fdbd00ac5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tolerance on boundary conditions", "Subsubsection",
 CellChangeTimes->{
  3.964105052374349*^9},ExpressionUUID->"6c166ea5-ab34-4e1b-b269-\
a49689618a80"],

Cell["\<\
It often happens that a boundary is not exactly where you think it is. Either \
due to numerical inaccuracy or through importing a model using STL etc.  You \
can apply a tolerance to the boundary condition to overcome this. A good way \
of doing this is to use an expression similar to this one.  \
\>", "Text",
 CellChangeTimes->{{3.9625911853989553`*^9, 3.962591216131837*^9}, {
   3.962591338353937*^9, 3.9625914342934027`*^9}, {3.962591515175953*^9, 
   3.96259152665123*^9}, 3.962591731391296*^9, {3.964275553804246*^9, 
   3.964275556411675*^9}, 
   3.964749381883415*^9},ExpressionUUID->"c819cbc5-a90f-41b6-8155-\
7ebfa806e713"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Abs", "[", 
   RowBox[{"z", "-", 
    RowBox[{"target", " ", "value", " ", "of", " ", "z"}]}], "]"}], "<", 
  "tolerance"}]], "Input",
 Evaluatable->False,
 CellChangeTimes->{{3.9625915384286337`*^9, 3.9625915742865877`*^9}, {
  3.964275275845071*^9, 3.9642753294411173`*^9}, {3.964275545843779*^9, 
  3.964275615273291*^9}},ExpressionUUID->"9f3a8f54-4014-4411-bb7a-\
45a0ae862166"],

Cell["eg .", "Text",
 CellChangeTimes->{{3.962591582977642*^9, 
  3.962591597181041*^9}},ExpressionUUID->"9ae82fe6-fb42-46a4-b3db-\
06c7e9b8eb0e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Abs", "[", 
   RowBox[{"x", "-", "10.5"}], "]"}], "<", "0.001"}]], "Input",
 CellChangeTimes->{{3.9625916012799253`*^9, 3.962591642300447*^9}, 
   3.9642753353589993`*^9, {3.964275628442593*^9, 
   3.964275652984571*^9}},ExpressionUUID->"58e5a5a5-6d72-4c8c-9248-\
61f20bebc2b4"],

Cell[TextData[{
 "which will  take the boundary to be between ",
 StyleBox["x==10.499", "inTextCode"],
 " and ",
 StyleBox["x==10.5.001", "inTextCode"],
 "."
}], "Text",
 CellChangeTimes->{{3.9625916655651217`*^9, 3.962591711050933*^9}, {
   3.96427566388841*^9, 3.9642756644432297`*^9}, 
   3.964749434146007*^9},ExpressionUUID->"d1146d7d-1bd1-400d-88da-\
d594e46da7e0"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Domain", "Subsection",
 CellChangeTimes->{{3.955966079103137*^9, 3.9559660809338493`*^9}, {
  3.970542297028111*^9, 3.970542302449842*^9}},
 CellID->118386576,ExpressionUUID->"8cead872-c2c8-4301-8802-dc70062639e2"],

Cell[TextData[{
 "The solution is found over a ",
 StyleBox["Region", "inTextCode"],
 " in space. The domain, which may be defined using standard Wolfram 3D \
graphics or it may be imported."
}], "Text",
 CellChangeTimes->{{3.960994449847452*^9, 3.9609945257796783`*^9}, 
   3.9612927476096153`*^9, {3.96408803510916*^9, 3.9640880413624897`*^9}, {
   3.970542319799356*^9, 3.97054235183971*^9}},
 CellID->1153325710,ExpressionUUID->"5434b373-1b87-4746-ab62-51c587a29313"],

Cell[TextData[{
 StyleBox["The domain is the region over which the solution is required e.g. \
a mesh and ",
  FontFamily->"Baskerville"],
 StyleBox["Element[ {x,y,z},domain]", "inTextCode",
  FontFamily->"Baskerville"],
 StyleBox[" asserts that the ",
  FontFamily->"Baskerville"],
 StyleBox["Element", "inTextCode",
  FontFamily->"Baskerville"],
 StyleBox[" belongs to the domain represented by the ",
  FontFamily->"Baskerville"],
 StyleBox["Region", "inTextCode",
  FontFamily->"Baskerville"],
 StyleBox[", which is normally a ",
  FontFamily->"Baskerville"],
 StyleBox["mesh", "inTextCode",
  FontFamily->"Baskerville"],
 StyleBox[".",
  FontFamily->"Baskerville"]
}], "Text",
 CellChangeTimes->{{3.967632658923956*^9, 3.9676327079550343`*^9}, {
   3.970538437571331*^9, 3.9705384391780367`*^9}, {3.970540917561318*^9, 
   3.97054095101954*^9}, {3.970540984848373*^9, 3.9705409955923433`*^9}, {
   3.970541114818822*^9, 3.970541123119874*^9}, {3.970541154021076*^9, 
   3.9705411572513*^9}, {3.970541237735463*^9, 3.9705413764608183`*^9}, 
   3.970542468233067*^9},
 CellID->1611352908,ExpressionUUID->"ab980417-6d98-4f40-bc3c-1a11a448666d"],

Cell["\<\
The domain, may be defined using standard Wolfram 3D graphics or it may be \
imported .\
\>", "Text",
 CellChangeTimes->{{3.970542414856166*^9, 3.970542447486082*^9}},
 CellID->22439259,ExpressionUUID->"54883950-c1c3-4949-aced-3e48d727f0d9"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Post processing", "Subsection",
 CellChangeTimes->{{3.9559847415854197`*^9, 3.9559847688364763`*^9}, 
   3.9559850697349787`*^9, 3.955985145889825*^9, {3.9559867261122837`*^9, 
   3.955986726113977*^9}, {3.956068531715589*^9, 3.956068561715476*^9}, {
   3.961293477890615*^9, 
   3.9612934818642807`*^9}},ExpressionUUID->"7682d7f5-1f15-4c16-8f11-\
b7f22ef35910"],

Cell["\<\
Once the displacement has been found further processing can take place to \
obtain the information required. such as stresses, strains or bending moments.\
\>", "Text",
 CellChangeTimes->{{3.961293490536105*^9, 
  3.961293557119502*^9}},ExpressionUUID->"349f1d11-cc87-4772-b88f-\
85f32197cbaf"],

Cell[CellGroupData[{

Cell["Example", "Subsubsection",
 CellFrame->{{0, 0}, {0, 2}},
 CellFrameColor->GrayLevel[0.75],
 CellChangeTimes->{{3.964775219340226*^9, 
  3.964775222473213*^9}},ExpressionUUID->"908234bd-ad91-4409-ad1f-\
bdc7c7278bd0"],

Cell["\<\
  The above procedure can be illustrated in the following example of a 5m \
square concrete plate, 200mm thick supporting a load of 15kPa plus self \
weight.\
\>", "Text",
 CellChangeTimes->{{3.961293567958482*^9, 3.961293574266674*^9}, 
   3.961295041230187*^9, 
   3.967649263912094*^9},ExpressionUUID->"8abf23d7-836e-406a-8bc4-\
89a2e2e79a24"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<NDSolve`FEM`\>\"", "]"}], 
  RowBox[{"(*", 
   RowBox[{"Call", " ", "to", " ", "finite", " ", "element", " ", "package"}],
    "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mesh", "=", 
    RowBox[{"ToElementMesh", "[", 
     RowBox[{"Cuboid", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "5", ",", "0.2"}], "}"}]}], "]"}], "]"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"The", " ", "region", " ", "is", "  ", "meshed"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vars", " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", " ", "y", ",", " ", "z"}], "]"}], ",", " ", 
        RowBox[{"v", "[", 
         RowBox[{"x", ",", " ", "y", ",", " ", "z"}], "]"}], ",", " ", 
        RowBox[{"w", "[", 
         RowBox[{"x", ",", " ", "y", ",", " ", "z"}], "]"}]}], "}"}], ",", 
      " ", 
      RowBox[{"{", 
       RowBox[{"x", ",", " ", "y", ",", " ", "z"}], "}"}]}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Output", " ", "variables"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"pars", "=", 
    RowBox[{"<|", 
     RowBox[{
      RowBox[{"\"\<YoungModulus\>\"", "->", 
       RowBox[{"30", " ", 
        SuperscriptBox["10", "9"]}]}], ",", 
      RowBox[{"(*", 
       RowBox[{"Material", " ", "parameters"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"\"\<PoissonRatio\>\"", "->", "0.3"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\"\<MassDensity\>\"", "->", "2500"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\"\<BodyLoadValue\>\"", "->", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"-", "9.81"}]}], "}"}]}]}], "\[IndentingNewLine]", "|>"}]}], 
   ";"}], "\t"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"op", "=", 
    RowBox[{"SolidMechanicsPDEComponent", "[", 
     RowBox[{"vars", ",", "pars"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", "boundaryConditions", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fixity", "=", 
   RowBox[{"DirichletCondition", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"w", "[", 
       RowBox[{"x", ",", "y", ",", "z"}], "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"x", "==", "0"}], "||", 
      RowBox[{"x", "==", "5"}], "||", 
      RowBox[{"y", "==", "0"}], "||", 
      RowBox[{"y", "==", "5"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"anchor", "=", 
   RowBox[{"DirichletCondition", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y", ",", "z"}], "]"}], "==", "0"}], ",", 
       RowBox[{
        RowBox[{"v", "[", 
         RowBox[{"x", ",", "y", ",", "z"}], "]"}], "==", "0"}]}], "}"}], ",", 
     
     RowBox[{
      RowBox[{"x", "==", "0"}], "\[And]", 
      RowBox[{"y", "==", "0"}], "\[And]", 
      RowBox[{"z", "==", "0"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"load", "=", 
   RowBox[{"SolidBoundaryLoadValue", "[", 
    RowBox[{
     RowBox[{"z", "==", "0.2"}], ",", "vars", ",", "pars", ",", 
     RowBox[{"<|", 
      RowBox[{"\"\<Pressure\>\"", "->", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"-", "15000"}]}], "}"}]}], "|>"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"displacement", "=", 
   RowBox[{"NDSolveValue", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"op", "==", "load"}], ",", "fixity", ",", "anchor"}], "}"}], ",",
      "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "[", 
        RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
       RowBox[{"v", "[", 
        RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
       RowBox[{"w", "[", 
        RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], "\[Element]", "mesh"}]}], 
    "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.9560207028728437`*^9, 3.95602087538258*^9}, 
   3.956021005225157*^9, {3.956021225130933*^9, 3.9560212274570303`*^9}, 
   3.9560218335267887`*^9, {3.956022980790372*^9, 3.956023004251141*^9}, 
   3.9560230939252*^9, {3.95604956575646*^9, 3.956049566494905*^9}, {
   3.956049624170456*^9, 3.956049625764469*^9}, 3.9560511641614513`*^9, {
   3.95605293238369*^9, 3.956052932755315*^9}, 3.956053136006056*^9, {
   3.956053330164036*^9, 3.9560533577639437`*^9}, 3.9560535647020206`*^9, {
   3.956053809813735*^9, 3.956053829587812*^9}, 3.9560539200985126`*^9, {
   3.956054469995105*^9, 3.9560544762465477`*^9}, {3.956055326029963*^9, 
   3.956055335015046*^9}, {3.9560701442919197`*^9, 3.956070209189021*^9}, {
   3.956109164031028*^9, 3.956109179460471*^9}, {3.961295072249106*^9, 
   3.961295151780054*^9}, {3.961295183283737*^9, 3.961295202656631*^9}, 
   3.961295248846492*^9, {3.9647494740097713`*^9, 
   3.964749508899139*^9}},ExpressionUUID->"a7369792-d14c-40f0-ab6d-\
2fb7ae7098a3"],

Cell["\<\
The  displacement at any point on slab can then be abstracted. Here the \
vertical displacement, in metres, at the centre of the slab is shown.\
\>", "Text",
 CellChangeTimes->{{3.961295284598137*^9, 3.961295292235044*^9}, {
  3.961295525110537*^9, 3.961295528636695*^9}, {3.970566903622815*^9, 
  3.970566907938609*^9}},ExpressionUUID->"aefc4e9f-551e-4996-9a4f-\
83660f9764d9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"displacement", "[", 
    RowBox[{"[", "3", "]"}], "]"}], "[", 
   RowBox[{"[", "0", "]"}], "]"}], "[", 
  RowBox[{"2.5", ",", "2.5", ",", "0.1"}], "]"}]], "Input",
 Editable->False,
 CellChangeTimes->{
  3.9612953445304003`*^9, {3.961295443710202*^9, 3.961295458754963*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"a24ee917-6820-408a-958a-e5aae253fa81"],

Cell[BoxData[
 RowBox[{"-", "0.0023953447545595166`"}]], "Output",
 Editable->False,
 CellEditDuplicate->True,
 CellChangeTimes->{
  3.9612953580802183`*^9, {3.9612954473099537`*^9, 3.961295461346349*^9}},
 CellLabel->"Out[14]=",ExpressionUUID->"bcab4bbf-68c4-4f8d-924b-d7255670ecce"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2", "Subsubsection",
 CellChangeTimes->{{3.9647752538985777`*^9, 
  3.964775259343813*^9}},ExpressionUUID->"1653488a-54f1-4101-bd55-\
b50fab5cfcd1"],

Cell["\<\
If the slab was fixed on all four edges, rather than simply supported the \
changes would be\
\>", "Text",
 CellChangeTimes->{{3.961295815232795*^9, 3.961295821411414*^9}, {
  3.967649303007695*^9, 
  3.9676493035917263`*^9}},ExpressionUUID->"04234dcc-f1b9-4be7-98f7-\
5856aa64b755"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"fixity", "=", 
   RowBox[{"SolidFixedCondition", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "==", "0"}], "||", 
      RowBox[{"x", "==", "5"}], "||", 
      RowBox[{"y", "==", "0"}], "||", 
      RowBox[{"y", "==", "5"}]}], ",", "vars", ",", "pars"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"displacement", "=", 
   RowBox[{"NDSolveValue", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"op", "==", "load"}], ",", "fixity"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", "w"}], "}"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], "\[Element]", "mesh"}]}], 
    "]"}]}], ";"}]}], "Input",
 Evaluatable->False,
 CellChangeTimes->{{3.956071568897134*^9, 3.956071581401347*^9}, 
   3.956108563105872*^9, {3.95610929516747*^9, 3.95610929793583*^9}, 
   3.9612958401316566`*^9, {3.9612959418811417`*^9, 3.961295978882682*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"3e489949-4743-4ae6-b500-ff36048409f5"],

Cell["and the displacement becomes", "Text",
 CellChangeTimes->{{3.956072826429245*^9, 3.9560728353374557`*^9}, {
  3.9612958659104633`*^9, 3.961295867295538*^9}, {3.967649313725862*^9, 
  3.9676493164168053`*^9}},ExpressionUUID->"64b6bc2b-0c82-40ec-b2c4-\
1fbcbf838424"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"displacement", "[", 
   RowBox[{"[", "3", "]"}], "]"}], "[", 
  RowBox[{"2.5", ",", "2.5", ",", "0.1"}], "]"}]], "Input",
 Evaluatable->False,
 CellChangeTimes->{3.961295893217225*^9},
 CellLabel->"In[22]:=",ExpressionUUID->"888af361-fa56-4de5-acce-96c809fdfc7f"],

Cell[BoxData[
 RowBox[{"-", "0.0007344566627782721`"}]], "Output",
 CellChangeTimes->{{3.961295885651062*^9, 3.9612958956329823`*^9}, 
   3.9612960158279753`*^9},
 CellLabel->"Out[22]=",ExpressionUUID->"90c0a370-e311-4717-81b5-0f8439c69029"]
}, Open  ]],

Cell[TextData[{
 "In this case, the final line of the ",
 StyleBox["NDSolveValue", "inTextCode"],
 " has been changed to ",
 StyleBox["{u,v,w}", "inTextCode",
  FontWeight->"SemiBold"],
 " and this results in the displacements not including the position. This \
makes further processing eg. for bending moments or plotting results in 2D, \
easier. However, if 3D plots are required then the full form  of ",
 StyleBox["{u[x,y,z],v[x,y,z],w[x,y,z]}", "inTextCode",
  FontWeight->"SemiBold"],
 " is necessary."
}], "Text",
 CellChangeTimes->{
  3.961296037103508*^9, {3.9612973118745527`*^9, 3.961297314077527*^9}, 
   3.9705672263182783`*^9},ExpressionUUID->"618b26ed-ea71-4807-b95a-\
7f21f7da7890"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Accuracy", "Subsection",
 CellChangeTimes->{{3.9612969917878447`*^9, 
  3.961296994109085*^9}},ExpressionUUID->"9ce9e620-60f1-4320-8096-\
c8d9cdb7d9a0"],

Cell[TextData[StyleBox["Finite elements are, inherently, an approximate \
method. However, the results can normally be found to any required degree of \
accuracy by reducing the mesh size or increasing the number of digits used in \
the calculations. However, for many cases, the standard meshing and number of \
digits is satisfactory.",
 FontSize->18]], "Text",
 CellChangeTimes->{{3.9612970050149097`*^9, 3.9612971242678127`*^9}, {
  3.9612971793791237`*^9, 3.9612972724964657`*^9}},
 FontSize->13,
 FontWeight->"Regular",ExpressionUUID->"f5ce3864-257b-4fc2-8daa-ebc3e06814ce"],

Cell[TextData[{
 StyleBox["Comparing these results with those from ",
  FontSize->18],
 StyleBox["Timoshenko 1959", "Reference",
  FontSize->18],
 StyleBox[" we get 2.30mm and 0.72 mm respectively . The values quoted by \
Timoshenko are stated as accurate to 3 significant figures so there is a \
small discrepancy. However, the values in Timoshenko are for a thin plate \
whereas the finite element case  takes into account the thickness. If the \
thickness in the above examples is reduced, the difference reduces until they \
match. Tabular values are also normally for a particular value of the Poisson \
ratio. If a different Poisson Ratio is appropriate it may affect the \
resulting value by up to 15 % (",
  FontSize->18],
 StyleBox["Roark 2012", "Reference",
  FontSize->18],
 StyleBox[")",
  FontSize->18]
}], "Text",
 CellChangeTimes->{{3.961296124785653*^9, 3.961296126402734*^9}, 
   3.961296294528903*^9, {3.9612963266899157`*^9, 3.9612963700831623`*^9}, 
   3.964315144335628*^9, {3.964760705657804*^9, 3.9647607263299313`*^9}, 
   3.9729027541171093`*^9},
 FontSize->13,
 FontWeight->"Regular",ExpressionUUID->"1de3d30c-9e47-4988-8b31-9f3eaed2aa8e"],

Cell[TextData[{
 StyleBox["Next -",
  FontColor->GrayLevel[0]],
 " ",
 Cell[BoxData[
  TemplateBox[{
   "\"\\!\\(\\*StyleBox[\\\"2.\\\",FontFamily->\\\"Source Sans \
Pro\\\",FontSize->18,FontWeight->\\\"SemiBold\\\",FontSlant->\\\"Italic\\\"]\\\
)\\!\\(\\*StyleBox[\\\" \\\",FontFamily->\\\"Source Sans \
Pro\\\",FontSize->18,FontWeight->\\\"SemiBold\\\",FontSlant->\\\"Italic\\\"]\\\
)\\!\\(\\*StyleBox[\\\"Rectangular\\\",FontFamily->\\\"Source Sans \
Pro\\\",FontSize->18,FontWeight->\\\"SemiBold\\\",FontSlant->\\\"Italic\\\"]\\\
)\\!\\(\\*StyleBox[\\\" \\\",FontFamily->\\\"Source Sans \
Pro\\\",FontSize->18,FontWeight->\\\"SemiBold\\\",FontSlant->\\\"Italic\\\"]\\\
)\\!\\(\\*StyleBox[\\\"slab\\\",FontFamily->\\\"Source Sans \
Pro\\\",FontSize->18,FontWeight->\\\"SemiBold\\\",FontSlant->\\\"Italic\\\"]\\\
)\"", {"Chapter2_Rectangular_Slab.nb", None}, "Chapter2_Rectangular_Slab.nb"},
   
   "HyperlinkDefault"]],
  CellChangeTimes->{{3.9744242644847403`*^9, 3.974424291797011*^9}, 
    3.974427498941486*^9, 3.974436399029193*^9, 3.974436875802096*^9},
  ExpressionUUID->"8ad28298-6bf1-45d3-aea6-11d0e7d32ae0"],
 "                                                                            \
      ",
 Cell[BoxData[
  TemplateBox[{
   "\"\\!\\(\\*StyleBox[\\\"Contents\\\",FontFamily->\\\"Source Sans \
Pro\\\",FontSize->18,FontWeight->\\\"SemiBold\\\",FontSlant->\\\"Italic\\\"]\\\
)\"", {"Contents.nb", None}, "Contents.nb"},
   "HyperlinkDefault"]],
  CellChangeTimes->{3.974433563494323*^9, 3.974436942557736*^9},
  TextAlignment->Center,
  Background->GrayLevel[0.85],ExpressionUUID->
  "9c30873a-7533-411f-b337-0d7933d2d4a2"]
}], "Subsubsection",
 CellChangeTimes->{{3.97183704200134*^9, 3.971837063536191*^9}, 
   3.971837115116831*^9, {3.971837162382868*^9, 3.971837165952989*^9}, 
   3.971837250378147*^9, 3.971837347949473*^9, {3.9744370816525497`*^9, 
   3.9744371082478533`*^9}},
 Background->GrayLevel[0.85],
 CellID->543313155,ExpressionUUID->"ee2dc2a2-253e-46ba-8715-ad344674647c"]
}, Open  ]]
}, Open  ]]
},
PrintingStyleEnvironment->"Elegant Printout",
WindowToolbars->{"RulerBar", "MultipurposeBar"},
WindowSize->{805, 976},
WindowMargins->{{90, Automatic}, {Automatic, 69}},
LightDark->"Light",
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
FrontEndVersion->"14.3 for Mac OS X ARM (64-bit) (July 8, 2025)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "MyBookStyles.nb"]]}, Visible -> False, 
  FrontEndVersion -> "14.3 for Mac OS X ARM (64-bit) (July 8, 2025)", 
  StyleDefinitions -> "PrivateStylesheetFormatting.nb"],
ExpressionUUID->"c3fd42a5-5b69-4079-81e6-fd3b37fcde47"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "overview"->{
  Cell[576, 22, 382, 7, 37, "Section",ExpressionUUID->"9000e81d-1adb-4a16-9934-246f43280c18",
   CellTags->"overview"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"overview", 56033, 1493}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[576, 22, 382, 7, 37, "Section",ExpressionUUID->"9000e81d-1adb-4a16-9934-246f43280c18",
 CellTags->"overview"],
Cell[961, 31, 710, 12, 90, "Text",ExpressionUUID->"ea3f7d97-a91d-4798-836b-b90746080b8e"],
Cell[1674, 45, 183, 2, 25, "Text",ExpressionUUID->"b7703d1e-b565-46b2-a271-e7b1ccfd0078",
 CellID->1984170498],
Cell[1860, 49, 205, 2, 25, "Text",ExpressionUUID->"10785b50-a4ae-4522-a32e-df01532f7258",
 CellID->1467278564],
Cell[2068, 53, 1291, 30, 41, "DisplayFormula",ExpressionUUID->"a58a913a-028c-4479-98fa-108a7a8c8dd6",
 CellID->379412489],
Cell[3362, 85, 205, 2, 25, "Text",ExpressionUUID->"53cc56a9-ed5a-4162-abce-aaf3b39c036c",
 CellID->1891200242],
Cell[CellGroupData[{
Cell[3592, 91, 235, 3, 25, "Subsection",ExpressionUUID->"c5c0f188-6828-461f-bffd-595a6b947fe3",
 CellID->1223278165],
Cell[3830, 96, 469, 11, 46, "Text",ExpressionUUID->"f6300ff0-2599-4b65-82a2-14f61fe6d6bb",
 CellID->285583223],
Cell[4302, 109, 339, 7, 26, "Text",ExpressionUUID->"0f047c9f-9182-423e-86db-cef7ea4c7a69",
 CellID->1505318698],
Cell[4644, 118, 879, 26, 52, "Text",ExpressionUUID->"b2a6452d-7461-4282-867e-63e1253200cb",
 CellID->1770035463],
Cell[5526, 146, 311, 4, 25, "Text",ExpressionUUID->"7c5052c9-2c66-4295-8170-4d485068908c",
 CellID->1724741210],
Cell[5840, 152, 590, 14, 26, "Text",ExpressionUUID->"267a10ce-cf22-4201-b0f2-cb60d2d34cff"],
Cell[6433, 168, 853, 20, 26, "Text",ExpressionUUID->"942a3a0d-2446-43a8-9d16-7cddad9c93e2"],
Cell[7289, 190, 528, 12, 41, "Text",ExpressionUUID->"5a046102-ce87-4f81-bfe3-94c75bc877cf"],
Cell[7820, 204, 901, 31, 25, "Input",ExpressionUUID->"9db12904-00ab-49e4-8206-87edb213f2ef",
 CellID->264532213],
Cell[8724, 237, 327, 10, 27, "Text",ExpressionUUID->"4c004224-250e-406b-a9dc-8924f7ffca44",
 CellID->151183715]
}, Open  ]],
Cell[CellGroupData[{
Cell[9088, 252, 169, 3, 25, "Subsection",ExpressionUUID->"97d8875c-c6ed-4454-a87d-24e1daf6f049"],
Cell[9260, 257, 712, 12, 41, "Text",ExpressionUUID->"9a5ca7cb-b63a-4cb5-8537-2ca8831be28a",
 CellID->950750164],
Cell[9975, 271, 1856, 52, 113, "Text",ExpressionUUID->"9be6d741-865c-4d3b-a444-8f62c4c251d4",
 CellID->1924935212],
Cell[11834, 325, 355, 5, 25, "Text",ExpressionUUID->"edcbfbeb-86fb-43e9-b58e-ec1f19789809"],
Cell[CellGroupData[{
Cell[12214, 334, 195, 3, 25, "Subsubsection",ExpressionUUID->"5590917a-7b53-4342-8cc1-794cceb8e8cf"],
Cell[12412, 339, 635, 12, 41, "ItemParagraph",ExpressionUUID->"328f5eb6-5146-4bbe-921c-fdca40f6a788"],
Cell[13050, 353, 2239, 68, 161, "Subitem",ExpressionUUID->"7d0ea4e5-8463-49f0-a482-8e41c95e3590"],
Cell[CellGroupData[{
Cell[15314, 425, 528, 12, 52, "Subitem",ExpressionUUID->"32ced986-c698-4b54-ba26-a32d8ce1a956"],
Cell[15845, 439, 341, 5, 24, "Subsubitem",ExpressionUUID->"91274449-1ebc-4c0a-918b-668af05efda1"]
}, Open  ]],
Cell[16201, 447, 938, 17, 146, "Subitem",ExpressionUUID->"33681a0f-302e-4d32-bfb7-686d786c880a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17176, 469, 365, 6, 52, "Subsubsection",ExpressionUUID->"32c02010-019c-448d-8006-da4842f02ffc"],
Cell[17544, 477, 443, 8, 36, "Text",ExpressionUUID->"2ccf8dde-cb55-433f-8471-fc19ebb01cb9"],
Cell[17990, 487, 288, 5, 36, "Text",ExpressionUUID->"1910f739-dbf1-4bac-958e-41a24ce0fa38"],
Cell[18281, 494, 346, 6, 26, "Subsubitem",ExpressionUUID->"7159d8b4-e5d8-4ec8-ad99-814a9bf708e3"],
Cell[18630, 502, 475, 9, 60, "Text",ExpressionUUID->"3fe44dd3-c081-4de0-b233-4711c87333ed"],
Cell[19108, 513, 404, 8, 60, "Text",ExpressionUUID->"11e81e19-392c-4ba7-9e14-86f610668824"],
Cell[19515, 523, 470, 11, 23, "Subsubitem",ExpressionUUID->"88a66a3f-7108-412d-b845-26b7483ca25b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20022, 539, 322, 5, 52, "Subsubsection",ExpressionUUID->"9d3b4d68-ecb3-4d47-a0fe-2ef74ffd4d63"],
Cell[20347, 546, 457, 9, 83, "Text",ExpressionUUID->"de52b838-a710-403d-90f9-2d194e543687"],
Cell[CellGroupData[{
Cell[20829, 559, 267, 4, 28, "Subitem",ExpressionUUID->"9f852bbb-83c8-4304-ab8e-3a69505d303e"],
Cell[21099, 565, 555, 14, 23, "Subsubitem",ExpressionUUID->"6fa1e672-445d-4675-95d2-76e90dd2c7aa"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21691, 584, 444, 7, 52, "Subitem",ExpressionUUID->"e7ad7903-5750-461d-9f7a-957712b89755"],
Cell[22138, 593, 375, 8, 24, "Subsubitem",ExpressionUUID->"d5eda755-e58d-423a-a368-c72da9bdeea2"]
}, Open  ]],
Cell[22528, 604, 879, 22, 55, "Subitem",ExpressionUUID->"58ddb436-52cc-4a50-a9b1-c4f39e8f3aaf"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23456, 632, 351, 4, 55, "Subsection",ExpressionUUID->"8dfed67b-5a9a-4f6c-a2ec-0ff8aa6a0665"],
Cell[23810, 638, 1624, 28, 272, "Text",ExpressionUUID->"31166b09-4824-4b71-9ef7-e3d440d175ef"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25471, 671, 186, 2, 55, "Subsection",ExpressionUUID->"53f4e9b2-d2d6-4f9c-9c72-3aba2d6da233"],
Cell[25660, 675, 561, 14, 83, "Text",ExpressionUUID->"223a92e7-f892-4b4d-acd9-817981bba5bf",
 CellID->1937046888],
Cell[26224, 691, 255, 5, 30, "Item",ExpressionUUID->"a9e32cfa-11c7-4b64-8c1e-7063e55565af"],
Cell[CellGroupData[{
Cell[26504, 700, 1490, 45, 29, "Subitem",ExpressionUUID->"78eccbc0-29b8-43cd-9d6b-4403c10c7594"],
Cell[CellGroupData[{
Cell[28019, 749, 841, 21, 68, "SubitemParagraph",ExpressionUUID->"b7d9deb7-4725-48a8-8b9a-af2cc73b46de"],
Cell[28863, 772, 511, 13, 31, "Item",ExpressionUUID->"81901aef-a357-4781-a761-01e4f995525a"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29423, 791, 1659, 46, 100, "Subitem",ExpressionUUID->"1c608910-16a1-43ae-be47-f75bbd193866"],
Cell[31085, 839, 410, 7, 30, "Item",ExpressionUUID->"0520b23e-629a-4ff7-96bf-35a8812737c0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31532, 851, 886, 24, 28, "Subitem",ExpressionUUID->"3c41ced6-9816-4419-96a8-32b18125e763"],
Cell[32421, 877, 799, 20, 44, "SubitemParagraph",ExpressionUUID->"c4e3a746-939d-4ce6-92bd-5eff68d12ce9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33257, 902, 324, 4, 55, "Subsubsection",ExpressionUUID->"9e8091d8-b2de-471e-a2ad-e04d4487c33d"],
Cell[33584, 908, 1364, 28, 194, "ItemParagraph",ExpressionUUID->"71b89045-65ff-47b0-9036-a8213cc23d88"],
Cell[34951, 938, 596, 14, 43, "Input",ExpressionUUID->"ae0fd256-5794-4782-8281-3a98dd7343ce",
 Evaluatable->False],
Cell[35550, 954, 724, 16, 43, "Input",ExpressionUUID->"bf00fd59-421f-4b2d-a574-c29fdbd00ac5",
 Evaluatable->False]
}, Open  ]],
Cell[CellGroupData[{
Cell[36311, 975, 159, 3, 52, "Subsubsection",ExpressionUUID->"6c166ea5-ab34-4e1b-b269-a49689618a80"],
Cell[36473, 980, 646, 11, 107, "Text",ExpressionUUID->"c819cbc5-a90f-41b6-8155-7ebfa806e713"],
Cell[37122, 993, 417, 10, 25, "Input",ExpressionUUID->"9f3a8f54-4014-4411-bb7a-45a0ae862166",
 Evaluatable->False],
Cell[37542, 1005, 146, 3, 36, "Text",ExpressionUUID->"9ae82fe6-fb42-46a4-b3db-06c7e9b8eb0e"],
Cell[37691, 1010, 313, 7, 25, "Input",ExpressionUUID->"58e5a5a5-6d72-4c8c-9248-61f20bebc2b4"],
Cell[38007, 1019, 371, 10, 36, "Text",ExpressionUUID->"d1146d7d-1bd1-400d-88da-d594e46da7e0"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[38427, 1035, 220, 3, 55, "Subsection",ExpressionUUID->"8cead872-c2c8-4301-8802-dc70062639e2",
 CellID->118386576],
Cell[38650, 1040, 471, 9, 60, "Text",ExpressionUUID->"5434b373-1b87-4746-ab62-51c587a29313",
 CellID->1153325710],
Cell[39124, 1051, 1146, 27, 83, "Text",ExpressionUUID->"ab980417-6d98-4f40-bc3c-1a11a448666d",
 CellID->1611352908],
Cell[40273, 1080, 251, 5, 60, "Text",ExpressionUUID->"54883950-c1c3-4949-aced-3e48d727f0d9",
 CellID->22439259]
}, Open  ]],
Cell[CellGroupData[{
Cell[40561, 1090, 368, 6, 55, "Subsection",ExpressionUUID->"7682d7f5-1f15-4c16-8f11-b7f22ef35910"],
Cell[40932, 1098, 304, 6, 60, "Text",ExpressionUUID->"349f1d11-cc87-4772-b88f-85f32197cbaf"],
Cell[CellGroupData[{
Cell[41261, 1108, 222, 5, 62, "Subsubsection",ExpressionUUID->"908234bd-ad91-4409-ad1f-bdc7c7278bd0"],
Cell[41486, 1115, 356, 8, 60, "Text",ExpressionUUID->"8abf23d7-836e-406a-8bc4-89a2e2e79a24"],
Cell[41845, 1125, 5200, 134, 327, "Input",ExpressionUUID->"a7369792-d14c-40f0-ab6d-2fb7ae7098a3"],
Cell[47048, 1261, 388, 7, 60, "Text",ExpressionUUID->"aefc4e9f-551e-4996-9a4f-83660f9764d9"],
Cell[CellGroupData[{
Cell[47461, 1272, 400, 10, 25, "Input",ExpressionUUID->"a24ee917-6820-408a-958a-e5aae253fa81"],
Cell[47864, 1284, 284, 6, 36, "Output",ExpressionUUID->"bcab4bbf-68c4-4f8d-924b-d7255670ecce"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[48197, 1296, 162, 3, 52, "Subsubsection",ExpressionUUID->"1653488a-54f1-4101-bd55-b50fab5cfcd1"],
Cell[48362, 1301, 293, 7, 60, "Text",ExpressionUUID->"04234dcc-f1b9-4be7-98f7-5856aa64b755"],
Cell[48658, 1310, 1106, 29, 81, "Input",ExpressionUUID->"3e489949-4743-4ae6-b500-ff36048409f5",
 Evaluatable->False],
Cell[49767, 1341, 271, 4, 36, "Text",ExpressionUUID->"64b6bc2b-0c82-40ec-b2c4-1fbcbf838424"],
Cell[CellGroupData[{
Cell[50063, 1349, 298, 7, 25, "Input",ExpressionUUID->"888af361-fa56-4de5-acce-96c809fdfc7f",
 Evaluatable->False],
Cell[50364, 1358, 241, 4, 36, "Output",ExpressionUUID->"90c0a370-e311-4717-81b5-0f8439c69029"]
}, Open  ]],
Cell[50620, 1365, 698, 16, 107, "Text",ExpressionUUID->"618b26ed-ea71-4807-b95a-7f21f7da7890"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[51367, 1387, 158, 3, 55, "Subsection",ExpressionUUID->"9ce9e620-60f1-4320-8096-c8d9cdb7d9a0"],
Cell[51528, 1392, 580, 9, 107, "Text",ExpressionUUID->"f5ce3864-257b-4fc2-8daa-ebc3e06814ce"],
Cell[52111, 1403, 1165, 24, 205, "Text",ExpressionUUID->"1de3d30c-9e47-4988-8b31-9f3eaed2aa8e"],
Cell[53279, 1429, 2006, 40, 69, "Subsubsection",ExpressionUUID->"ee2dc2a2-253e-46ba-8715-ad344674647c",
 CellID->543313155]
}, Open  ]]
}, Open  ]]
}
]
*)

